function S=process_sum_of_squares_ftA(par,A,epA,epB,KAb,KBa,L,V,presnost)
%S=process_sum_of_squares_ftA(par,A,epA,epB,KAb,KBa,L,V,presnost)
%Calculates the sum of squares of differences between measured and calculated concentrations of the substance A. 
%"par" is a vector that contains: quantum yield of the reaction A -> B, quantum yield B -> A, initial concentration of the substance A 
%"A": matrix with measurements: 
%  1. column is time, 
%  2. column contains numbers of impacted photons (total number from the beginning of the irradiation), 
%  3. column are the concentration values of the substance A [m-3], 
%  4. column are the concentration values of the substance B [m-3] 
%"epA": cross section of excitation of the substance A [m2] 
%"epB": cross section of excitation of the substance B [m2] 
%"KAb": Rate constant of the thermal reaction A -> B [s-1] 
%"KBa": Rate constant of the thermal reaction B -> A [s-1] 
%"L": cuyvette length [m] 
%"V": sample volume [m-3]
%"presnost": %The level of precision in the numerical calculation in the function "process_ftA.m". 
% Higher "presnost" leads to shorter calculation step, i.e. to more accurate result but to slower calculation. 
%"S": sum of squares of residuals 

n=length(A(:,1));
N=mean(A(:,3)+A(:,4)); %total concentration (A+B) 
kvAb=par(1); 
kvBa=par(2);
NA0=par(3);
NB0=N-NA0; %initial concentration of the substance B

Cas=A(:,[1 2]); 
Mt=process_ftA(kvAb,kvBa,KAb,KBa,NA0,NB0,epA,epB,L,V,Cas,presnost,0); %Numerical calculation of the evolution of both A and B concentrations
S=0; 
for j=1:n, 
 [nic,por]=min(abs(Mt(:,2)-A(j,2)));
 if Mt(por,2)-A(j,2)>0
  makt=Mt(por-1,3) + (Mt(por,3)-Mt(por-1,3))*(A(j,2)-Mt(por-1,2))/(Mt(por,2)-Mt(por-1,2));
 elseif Mt(por,2)-A(j,2)<0
  makt=Mt(por,3) + (Mt(por+1,3)-Mt(por,3))*(A(j,2)-Mt(por,2))/(Mt(por+1,2)-Mt(por,2));
 else 
  makt=Mt(por,3);
 end
 S=S+(A(j,3)-makt)^2; %the sum of squares
end
